local TweakData = {
	HEALTH_ADD = 0.4,
	HEALTH_RECOVERY = 1,
	HEALTH_LOSS = 0.054,
	MAX_REDUCTION = 15,
	SPEED_UP_COOLDOWN = 1,
	IMMORTAL_BODY_TIME = 2,
	IMMORTAL_BODY_SPEED_UP = 1,
	IMMORTAL_BODY_SPEED_UP_2 = 2
}

blt.xaudio.setup()
local mPath = ModPath
local XPenglaiActive

if RequiredScript == "lib/managers/playermanager" then
	--init
	Hooks:PostHook(PlayerManager, "init", "Penglai_init", function(self)
		self._immortal_body_t = TweakData.IMMORTAL_BODY_TIME
		self._Penglai_activate = false
		self._Penglai_t = 0
		self._Penglai_life_t = 0.5
		self._Penglai_flame = false
		self._max_reduction = TweakData.MAX_REDUCTION
		self._max_reduction_2 = TweakData.MAX_REDUCTION_2
		self._is_flame = false
		self.can_revive = true
		DB:create_entry(
			Idstring("texture"),
			Idstring("guis/dlcs/peng_lai/textures/penglai_active"),
			mPath .. "assets/textures/penglai_active.texture"
		)
	end)
	
	--update
	Hooks:PostHook(PlayerManager, "update", "Penglai_update", function(self, t, dt)
		if not self:player_unit() then
			return
		end
		
		if not self:has_category_upgrade("player","Penglai_health_recovery") then
			return
		end

		if managers.player:current_state() == "bleed_out" or managers.player:current_state() == "fatal" then
			self._Penglai_t = 0
			
			if XPenglaiActive then
				XPenglaiActive:close(true)
			end
		end

		local character_damage = self:player_unit():character_damage()
		local max_health = character_damage:_max_health()
		local current_health = character_damage:get_real_health()
		
		if self._immortal_body_t <= 0 then
			character_damage:change_health(max_health * 0.01)
		end
		
		self._immortal_body_t = self._immortal_body_t >= 0 and self._immortal_body_t - dt or TweakData.IMMORTAL_BODY_TIME
		self._Penglai_t = self._Penglai_t > 0 and self._Penglai_t - dt or 0
		
		if self._Penglai_t == 0 and self._Penglai_activate then
			self._Penglai_activate = false
			character_damage:change_armor(character_damage:_max_armor())
		end
		
		if self._Penglai_activate then
			if self._Penglai_life_t <= 0 then
				character_damage:change_health(-(max_health * 0.0252))
				if current_health == 0 and (managers.player:current_state() == "bleed_out" or managers.player:current_state() == "fatal") then
					character_damage:force_into_bleedout()
				end
				
			end
			self._Penglai_life_t = self._Penglai_life_t >= 0 and self._Penglai_life_t - dt or 1
		end
		
		-- HUD FLASH
		local hud = managers.hud:script(PlayerBase.PLAYER_INFO_HUD_FULLSCREEN_PD2)
		if not hud.panel:child("penglai_left") then
			penglai_left = hud.panel:bitmap({
				name = "penglai_left",
				visible = false,
				texture = "guis/dlcs/peng_lai/textures/penglai_active",
				layer = 0,
				color = Color(1, 0, 0),
				blend_mode = "add",
				w = hud.panel:w(),
				h = hud.panel:h(),
				x = 0,
				y = 0 
			})
		end
		
		local penglai_left = hud.panel:child("penglai_left")
		if self._Penglai_activate and penglai_left then
			penglai_left:set_visible(true)
			local hudinfo = managers.hud:script(PlayerBase.PLAYER_INFO_HUD_PD2)
			penglai_left:animate(hudinfo.flash_icon, 4000000000)
		elseif hud.panel:child("penglai_left") then
			penglai_left:stop()
			penglai_left:set_visible(false)
		end
		
		if penglai_left and not self._Penglai_activate then
			penglai_left:set_visible(false)
		end
		
	end)
	
	--Use Device
	local PlayerManager_attempt_ability = PlayerManager.attempt_ability
	function PlayerManager:attempt_ability(...)
		if not self:player_unit() then
			return PlayerManager_attempt_ability(self, ...)
		end

		if not self:has_category_upgrade("player","Penglai_life") then
			return PlayerManager_attempt_ability(self, ...)
		end
		
		local grenade_amount = self:get_grenade_amount(managers.network:session():local_peer():id())
		if grenade_amount <= 0 then
			return
		end
		
		-- if self._Penglai_activate then
			-- return
		-- end

		local character_damage = self:player_unit():character_damage()
		local max_health = character_damage:_max_health()
		local current_health = character_damage:get_real_health()
		
		if self:has_category_upgrade("player","Penglai_flame") and (managers.player:current_state() == "bleed_out" or managers.player:current_state() == "fatal") then
			if self.can_revive then
				self._Penglai_flame = true
				self.can_revive = false
				character_damage:revive()
				character_damage:change_health(max_health - current_health)	
				PlayerManager_attempt_ability(self, ...)
				return
			else
				return
			end
		end
		
		PlayerManager_attempt_ability(self, ...)
		self._Penglai_activate = true

		--helath and armor add 
		character_damage:change_health(max_health - current_health)
		character_damage:change_armor(-character_damage:get_real_armor())
		
		-- G CD Re
		self._Penglai_t = 12
		playPenglaiSound()
	end
	
	--health_skill_multiplier
	local PlayerManager_health_skill_multiplier = PlayerManager.health_skill_multiplier
	function PlayerManager:health_skill_multiplier(...)
		local Penglai_multiplier = 0
		
		if self:has_category_upgrade("player","Penglai_health") then
			Penglai_multiplier = Penglai_multiplier + TweakData.HEALTH_ADD
		end
		
		return PlayerManager_health_skill_multiplier(self, ...) + Penglai_multiplier
	end
	
	local PlayerManager_damage_reduction_skill_multiplier = PlayerManager.damage_reduction_skill_multiplier
	function PlayerManager:damage_reduction_skill_multiplier(...)
		local multiplier = PlayerManager_damage_reduction_skill_multiplier(self, ...)
		
		if managers.player._Penglai_activate then
			multiplier = multiplier - 0.75
		end

		return multiplier
	end
	
	--On Kill Shot
	Hooks:PostHook(PlayerManager, "on_killshot", "Penglai_on_killshot", function(self, killed_unit, variant, headshot, weapon_id)
		if self:has_category_upgrade("player","Penglai_health_recovery") then
			local immortal_body_speed_up = self:has_category_upgrade("player","Penglai_life") and TweakData.IMMORTAL_BODY_SPEED_UP_2 or TweakData.IMMORTAL_BODY_SPEED_UP
			self._immortal_body_t = self._immortal_body_t - immortal_body_speed_up
		end
		
		if self:has_category_upgrade("player","Penglai_volition") then
			managers.player:speed_up_grenade_cooldown(0)
		end
		
		if self._Penglai_activate and variant == "melee" then
			local character_damage = self:player_unit():character_damage()
			local max_health = character_damage:_max_health()
			character_damage:change_health(max_health * 0.2)
		end
	end)

	--------------------/////////////////////Grenades Fix/////////////////////--------------------
Hooks:OverrideFunction(PlayerManager, "update_grenades_to_peer", function(self, peer)
--function PlayerManager:update_grenades_to_peer(peer)
	local peer_id = managers.network:session():local_peer():id()

	if self._global.synced_grenades[peer_id] then
		local grenade = self._global.synced_grenades[peer_id].grenade
		local tweak = tweak_data.blackmarket.projectiles[grenade]
		if tweak.based_on then 
			grenade = tweak.based_on
		end
		local amount = self._global.synced_grenades[peer_id].amount

		peer:send_queued_sync("sync_grenades", grenade, Application:digest_value(amount, false), 0)
	end
end)

Hooks:OverrideFunction(PlayerManager, "update_grenades_amount_to_peers", function(self, grenade, amount, register_peer_id)
--function PlayerManager:update_grenades_amount_to_peers(grenade, amount, register_peer_id)
	local peer_id = managers.network:session():local_peer():id()
	
		local tweak = tweak_data.blackmarket.projectiles[grenade]
		if tweak.based_on then 
			grenade = tweak.based_on
		end
		
	managers.network:session():send_to_peers_synched("sync_grenades", grenade, amount, register_peer_id or 0)
	self:set_synced_grenades(peer_id, grenade, amount, register_peer_id)
end)

--fixes the synced (spoofed) grenade data being used for the actual data- specifically, cooldown
Hooks:OverrideFunction(PlayerManager, "add_grenade_amount", function(self, amount, sync)
--function PlayerManager:add_grenade_amount(amount, sync)
	local peer_id = managers.network:session():local_peer():id()
	local grenade = managers.blackmarket:equipped_grenade() --self._global.synced_grenades[peer_id].grenade
	local tweak = tweak_data.blackmarket.projectiles[grenade]
	local max_amount = self:get_max_grenades_by_peer_id(peer_id)
	local icon = tweak.icon
	local previous_amount = self._global.synced_grenades[peer_id].amount

	if amount > 0 and tweak.base_cooldown then
		managers.hud:animate_grenade_flash(HUDManager.PLAYER_PANEL)
	end

	amount = math.min(Application:digest_value(previous_amount, false) + amount, max_amount)

	if amount < max_amount and tweak.base_cooldown then
		self:replenish_grenades(tweak.base_cooldown)
	end

	managers.hud:set_teammate_grenades_amount(HUDManager.PLAYER_PANEL, {
		icon = icon,
		amount = amount
	})
	self:update_grenades_amount_to_peers(grenade, amount, sync and peer_id)
end)
	--------------------/////////////////////Grenades Fix/////////////////////--------------------
	
	function PlayerManager:Penglai_Max_Reduction(index)
		if index == 1 or not index then
			return self._max_reduction
		elseif index == 2 then
			return self._max_reduction_2
		end
	end
	
	function playPenglaiSound()
		XPenglaiActive = XAudio.Source:new(XAudio.Buffer:new(mPath.."assets/sounds/XPenglaiActive.ogg"))
		XPenglaiActive:set_volume(1.0)
	end
end